/// <reference name="MicrosoftAjax.debug.js" />
/// <reference name="MicrosoftAjaxTimer.debug.js" />
/// <reference name="MicrosoftAjaxWebForms.debug.js" />
/// <reference name="AjaxControlToolkit.ExtenderBase.BaseScripts.js" assembly="AjaxControlToolkit" />
/// <reference path="../ExtenderBase/BaseScripts.js" />
/// <reference path="../Compat/Timer/Timer.js" />
/// <reference path="../Common/Common.js" />
/// <reference path="../Animation/Animations.js" />

Type.registerNamespace('AnimatedImageRotator');

AnimatedImageRotator.AnimatedImageRotatorBehavior = function(element) {
    AnimatedImageRotator.AnimatedImageRotatorBehavior.initializeBase(
                                                            this, [element]);

    this._imageIndex = 0;
    this._imageArray = new Array();
    this._rotationInterval = null;
    this._fadeAnimation = null;
    this._timer = null;
    this._onImageLoadHandler = null;
}
AnimatedImageRotator.AnimatedImageRotatorBehavior.prototype = {
    initialize : function() {
        AnimatedImageRotator.AnimatedImageRotatorBehavior.callBaseMethod(
                                                         this, 'initialize');
       this._imageArray = Sys.Serialization.JavaScriptSerializer.deserialize(
                                                         this._imageArray);
        var element = this.get_element();
        if(this._imageArray)
        {
            this._imageArray[this._imageArray.length] = element.src;
        }
        
        if(this._rotationInterval == null)
            this._rotationInterval = 3;
        
        if(this._fadeAnimation == null)
        {
            this._fadeAnimation = new AjaxControlToolkit.Animation.FadeAnimation(
                                 element, this._rotationInterval/20, 150,
                                 AjaxControlToolkit.Animation.FadeEffect.FadeIn, 
                                 0, 1, true);
        }
        if (element) 
         {
            this._onImageLoadHandler = Function.createDelegate(this, 
                                                            this._onImageLoad);
            $addHandler(element, 'load', this._onImageLoadHandler);
        }
        
        if(this._timer == null)
            this._timer = new Sys.Timer();
        
        this._timer.set_interval(this._rotationInterval * 1000);
        this._timer.add_tick(Function.createDelegate(this, this._rotateImage));
        this._timer.set_enabled(true);
    },

    dispose : function() {
        AnimatedImageRotator.AnimatedImageRotatorBehavior.callBaseMethod(
                                                               this, 'dispose');
        
        var element = this.get_element();
        if (element) {
            if (this._onImageLoadHandler) {
                $removeHandler(element, 'load', this._onImageLoadHandler);
                this._onImageLoadHandler = null;
            }
        }
        
        if (this._timer) 
        {
            this._timer.dispose();
            this._timer = null;
        }
        
        if (this._fadeAnimation)
        {
            this._fadeAnimation.dispose();
            this._fadeAnimation = null;
        }    
        
        this._imageArray = null;
    },
    _onImageLoad: function(){
        if(this._fadeAnimation)
            this._fadeAnimation.play();
    },
    get_rotationInterval: function(){
        return this._rotationInterval;
    },
    set_rotationInterval: function(value){
        this._rotationInterval = value;
    },
    get_imageArray: function(){
        return this._imageArray;
    },
    set_imageArray: function(value){
        this._imageArray = value;
    },
    _rotateImage: function(){
        var element = this.get_element();
        if(element)
        {
            element.src = this._imageArray[this._imageIndex++];
            if(this._imageIndex > this._imageArray.length - 1)
                this._imageIndex = 0;
        }
    }
}
AnimatedImageRotator.AnimatedImageRotatorBehavior.registerClass(
            'AnimatedImageRotator.AnimatedImageRotatorBehavior', 
            AjaxControlToolkit.BehaviorBase);
